#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <gtk/gtk.h>
#include "mplinux.h"
#include "useful.h"

GtkWindow* MainWindow;

void sighup_handler(gint i) {
     g_signal_emit_by_name(MainWindow,"destroy",0,NULL);
}

void create_remover_script() {
     FILE* fp;
     gchar* cmd ="#!/bin/sh\nkill -HUP ";
     gchar pid[10];
     
     if (getenv("REMOVER") == NULL)
	  return;

     fp = fopen(getenv("REMOVER"),"w");
     if (!fp) return;

     fwrite(cmd,1,strlen(cmd),fp);
     sprintf(pid,"%d",getpid());
     fwrite(pid,1,strlen(pid),fp);
     fclose(fp);
     chmod(getenv("REMOVER"),S_IXUSR | S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IXGRP);     
}

void Disclaimer() {
     GtkWidget* dialog;
     gint ret;
     dialog = gtk_message_dialog_new (NULL,0,
				      GTK_MESSAGE_QUESTION,
				      GTK_BUTTONS_YES_NO,
 "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nDo you agree?");
     w_center_window(GTK_WINDOW(dialog));
     ret = gtk_dialog_run (GTK_DIALOG (dialog));
     
     gtk_widget_destroy (dialog);
     if (ret == -9) {
	  unlink("/tmp/mplinuxman.pid");
	  exit(0);
     }

}

void ReadConfig() {
     gchar* c;
     gint width;
     gint height;
     gint i;

     if ( (cfg_Init() == CFG_NEW)) {
	  Disclaimer();
     }

      c = cfg_Read("geometry","window width","722");
      width = atoi(c);

      c = cfg_Read("geometry","window height","460");
      height = atoi(c);

      gtk_window_set_default_size(MainWindow,width,height);
      MW_SET("win_width",width);
      MW_SET("win_height",height);

      c = cfg_Read("geometry","splitter position","345");
      i = atoi(c);
      gtk_paned_set_position(GTK_PANED(MW_GET("splitter")),i);      
      
      c = cfg_Read("geometry","splitter2 position","190");
      i = atoi(c);
      gtk_paned_set_position(GTK_PANED(MW_GET("splitter2")),i);      
	  
	  c = cfg_Read("geometry","playlist column width","250");
      i = atoi(c);
	  gtk_tree_view_column_set_fixed_width(MW_GET("left_treeview_column"),i);
      
	  c = cfg_Read("geometry","flash column width","250");
      i = atoi(c);
	  gtk_tree_view_column_set_fixed_width(MW_GET("right_flash_treeview_column"),i);
      
	  c = cfg_Read("geometry","smartmedia column width","250");
      i = atoi(c);
	  gtk_tree_view_column_set_fixed_width(MW_GET("right_smartmedia_treeview_column"),i);
      
      c = cfg_Read("options","tool bar text","1");
      if (atoi(c) ) {
	 gtk_toolbar_set_style(GTK_TOOLBAR(MW_GET("left_toolbar")),
					   GTK_TOOLBAR_BOTH);
	 gtk_toolbar_set_style(GTK_TOOLBAR(MW_GET("right_toolbar")),
					   GTK_TOOLBAR_BOTH);
     }
  
      c = cfg_Read("options","startup load list","1");
      if (atoi(c))
	   menuitem_LoadPlaylist(NULL,3,NULL);

	  c = cfg_Read("options","startup connect","1");
      if (atoi(c))
	   gtk_timeout_add (1000,(GtkFunction)StartupConnect,NULL);            

      c = cfg_Read("options","exit on unplugged","0");
      if (atoi(c))
	   create_remover_script();

      c = cfg_Read("options","print debug info","0");
      if (atoi(c))
	   mpl_PrintDebugInfo(atoi(c));

      c = cfg_Read("options","user supplied id","0");
      if (atoi(c))
          mpl_set_device_id(1,cfg_Read("options","supplied vendor id","0000"),
                              cfg_Read("options","supplied product id","0000"));
}

gboolean check_for_pid() {
     FILE* fp;
     gchar pid[10];

     fp = fopen("/tmp/mplinuxman.pid","r");
     if (fp) {
	  fclose(fp);
	  return TRUE;
     }
     
     fp = fopen("/tmp/mplinuxman.pid","w");
     if (!fp) return TRUE;

     sprintf(pid,"%d",getpid());
     fwrite(pid,1,strlen(pid),fp);
     fclose(fp);
     return FALSE;
}

int main(int argc,char** argv) {

#ifdef NLS	
	bindtextdomain (PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset(PACKAGE,"UTF-8");
	textdomain (PACKAGE);
#endif

	gtk_init (&argc,&argv);

	if (check_for_pid() == TRUE) {
		GtkWidget* dialog;
		gint ret;
		
		//gtk_init (&argc,&argv);
		g_print(_("Mplinuxman is already running\n"));
		
		dialog = gtk_message_dialog_new (NULL,0,
		GTK_MESSAGE_ERROR,
		GTK_BUTTONS_YES_NO,	    
		_("Found /tmp/mplinuxman.pid. Mplinuxman might be already running.\n\nIf the program crashed before. Please report it to\nhttp://mplinuxman.sourceforge.net\n\nDo you want to continue loading anyway?"));
		w_center_window(GTK_WINDOW(dialog));
		ret = gtk_dialog_run (GTK_DIALOG (dialog));
		gtk_widget_destroy (dialog);
		if (ret == -9)
			exit(0);
	}

	g_thread_init(NULL);
	if (!g_thread_supported()) {
		g_print(_("gthreads not supported\n"));
		g_thread_init (NULL);
	}
	gdk_threads_init();
	 if (1) {
		const gchar* sstr = "style \"mystyle\"\n {\n GtkToolbar::shadow_type = GTK_SHADOW_NONE \n}\nclass \"GtkToolbar\" style \"mystyle\"\n";   
		gtk_rc_parse_string(sstr);		  
	  }
	
	
	create_main_window(&MainWindow);
	ReadConfig();
	gtk_widget_show_all(GTK_WIDGET(MainWindow));
	//   w_center_window(MainWindow);
	
	signal(SIGHUP,sighup_handler);
	
	gtk_main();
	unlink("/tmp/mplinuxman.pid");
	return 0;
}
