# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this file,
# You can obtain one at http://mozilla.org/MPL/2.0/.
import json

FIRST_LINE = "// This file was generated by generate_thread_allows.py. DO NOT EDIT."


def generate_allows(input_paths):
    """
    This script reads in the ThreadAllows.txt and ThreadFileAllows.txt lists
    and generates a header file containing a two arrays of allowed threads.
    These can be the following formats:
        -Files which the checker should ignore
            These files either contain definitions of NS_NewNamedThread or
            use args which the plugin can't cast (such as func args).
        -Thread names which the checker should ignore
            Specifies which individual thread names to ignore.
    """
    file_list = []
    name_list = []
    lines = set()

    for path in input_paths:
        with open(path) as file:
            lines.update(file.readlines())

    for line in sorted(lines):
        """
        We are assuming lines ending in .cpp, .h are files. Threads should
        NOT have names containing filenames. Please don't do that.
        """
        line = line.strip()
        if line.endswith(".cpp") or line.endswith(".h"):
            file_list.append(line)
        else:
            name_list.append(line)
    file_list_s = ",\n  ".join(json.dumps(elem) for elem in file_list)
    name_list_s = ",\n  ".join(json.dumps(elem) for elem in name_list)
    output_string = (
        FIRST_LINE
        + """

static const char *allow_thread_files[] = {
  %s
};

static const char *allow_thread_names[] = {
  %s
};

    """
        % (file_list_s, name_list_s)
    )
    return output_string


def generate_file(output, *input_paths):
    output.write(generate_allows(input_paths))
