// Lossless reachability set storage -*- c++ -*-

#ifndef FULLSET_H_
# define FULLSET_H_
# ifdef __GNUC__
#  pragma interface
# endif // __GNUC__

# include "StateSet.h"
# include "file.h"

/** @file FullSet.h
 * Transient, lossless reachability set storage
 */

/* Copyright  2002-2003 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

/** Lossless reachability set storage */
class FullSet : public StateSet
{
public:
  /** Constructor */
  FullSet ();
private:
  /** Copy constructor */
  FullSet (const class FullSet& old);
  /** Assignment operator */
  class FullSet& operator= (const class FullSet& old);
public:
  /** Destructor */
  ~FullSet ();

  /** Set up the storage
   * @param path	flag: open the counterexample path file?
   * @return		true if the initialization succeeded
   */
  bool init (bool path);

  /** Clear the storage */
  void clear ();

private:
  /** Add a state to the graph
   * @param state	the encoded state
   * @param size	length of the encoded state, in bytes
   * @return		true if the state was enqueued to mySearch
   */
  bool do_add (const void* state,
	       size_t size);

protected:
  /** Get a deflated state from myPathFile
   * @param pos		file offset to the state
   * @param size	(output) length of the encoded state
   */
  word_t* getState (long pos, size_t* size) const;

public:
  /** Fetch an encoded state
   * @param tail	flag: retrieve from tail of list instead of head
   * @param size	(output) length of the encoded stream
   * @return		the encoded state
   */
  word_t* pop (bool tail, size_t& size);

private:
  /** The state hash */
  class BTree* myHash;
  /** The state storage */
  file_t myStates;
};

#endif // FULLSET_H_
