## API changes from 1.10 to 1.12

libUPnP version 1.12 contains some API changes compared to v1.10, this page
contains explanation of these changes and what users need to do to migrate
from using 1.10 to 1.12.

### list.h header changed

The `list.h` header was replace by a different version, now all symbols
are properly namespaced with a Upnp prefix. This header was never intended
to be used directly by libUPnP users, so not many should be affected.

As a side-effect of the header change, libUPnP no longer defines the
`true` and `bool` macros. Users that need those should define their
own or use `<stdbool.h>`. Additionally the following macros are no
longer defined:
- `prefetch`
- `container_of`
- `READ_ONCE`
- `WRITE_ONCE`

And various list-specific macros are gone.
For details see the discussion at the Github PRs [#128][gh-pr128] and [#129][gh-pr129].

[gh-pr128]: https://github.com/mrjimenez/pupnp/pull/128
[gh-pr129]: https://github.com/mrjimenez/pupnp/pull/129

### Removal of TRUE, FALSE macros and BOOL type

Previously `ixml.h` used to define `TRUE` and `FALSE` and declared a `BOOL` typedef.
Those macros and the typedef were removed in 10.12 in favor of just using `int` and
`1` and `0` for true and false.

If your code relied on these being available, the cleanets fix would be to use `<stdbool.h>`
instead. Alternatively if you can't use that or it would require too many changes to your
existing source code, you can define the macros and typedef in your headers:

```c
#ifndef __OBJC__ 
    typedef int BOOL;
#else
    /* When using Objective-C, include objc.h which defines BOOL */
    #include <objc/objc.h>
#endif

#define TRUE 1
#define FALSE 0
```
