#!/usr/bin/python3
#
# This file is part of Freedom Maker.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
Module to provide ability to run this freedommaker package.

Run the package as:
  $ sudo python3 -m freedommaker <TARGET>
where:
  <TARGET> is one of:
  $ grep -r 'machine = ' freedommaker/builders/ | cut -d '=' -f 2
eg:
  $ sudo python3 -m freedommaker a20-olinuxino-lime2

To see the full list of options read the help-page:
  $ python3 -m freedommaker --help
"""

from .application import Application


if __name__ == '__main__':
    Application().run()
